#!/bin/sh

# Find the name of the script
cd $( dirname $0 )
SCRIPT_DIR="$( pwd )"
CONFIG="/mnt/data/hmi/pew/deploy/node/config/pew.json"
CONFIG_RTC="/mnt/data/hmi/pew/deploy/node/config/pew_rtc.json"

export PATH="$SCRIPT_DIR/bin:/sbin:/bin:/usr/sbin:/usr/bin"
export LD_LIBRARY_PATH="$SCRIPT_DIR/lib"

# Typical content during automatic start by jmLauncher
# $SCRIPT_DIR         /mnt/data/hmi/pew/deploy
# $LD_LIBRARY_PATH   /mnt/data/hmi/pew/deploy/lib
# $@                -kiosk

if [ ! -e "$CONFIG" -a ! -h "$CONFIG" ]
then
	cp "$SCRIPT_DIR/config_default/pew.json" "$CONFIG"
	cp "$SCRIPT_DIR/config_default/pew_rtc.json" "$CONFIG_RTC"
fi

/mnt/data/hmi/pew/deploy/bin/pew_main -l5
